<?php

namespace App\Console\Commands;

use App\Models\Attendance;
use Illuminate\Console\Command;
use DB;

class AttendanceFetch extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'attendance:fetch';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Fetch attendance from Microsoft Access (MDB) and store in MySQL';

    /**
     * Execute the console command.
     */
    public function handle(): void
    {
               // ODBC Connection to Access Database
               $connection = odbc_connect("att2000", "", "");

               // MySQL Connection
               $db = mysqli_connect('localhost', 'root', '', 'device');


               if (!$connection) {
                   die("ODBC connection failed: " . odbc_errormsg());
               }

               if (!$db) {
                   die("MySQL connection failed: " . mysqli_connect_error());
               }

               // Set MySQL time zone if needed
               // mysqli_query($db, "SET time_zone = 'Asia/Dhaka';");

               while (1) {
                   // Data In: Retrieve data from Microsoft Access and insert into MySQL
                   $sql = "SELECT TOP 10000 USERID, CHECKTIME FROM CHECKINOUT ORDER BY CHECKTIME DESC"; // Fetch data ordered by CHECKTIME in ascending order
                   $result = odbc_exec($connection, $sql);
                   if (!$result) {
                       die("Query execution failed: " . odbc_errormsg());
                   }

                   $i = 0;

                   while (odbc_fetch_row($result)) {
                       $user_id = odbc_result($result, 1);
                       $checktime = odbc_result($result, 2);


                       // Convert CHECKTIME to Unix timestamp and format it for MySQL
                       $checktime = strtotime($checktime);  // Convert to Unix timestamp
                       $checktime = date('Y-m-d H:i:s', $checktime);  // Format it for MySQL

                       // Retrieve additional user info from the USERINFO table
                       $sql = "SELECT * FROM USERINFO WHERE USERID = " . $user_id;
                       $info = odbc_exec($connection, $sql);


                       while (odbc_fetch_row($info)) {
                           $user_id = odbc_result($info, 2);

                           // Check if the attendance already exists in MySQL
                           $sql = "SELECT * FROM attendances WHERE user_id = '$user_id' AND punch_time = '$checktime'";
                           $check_result = mysqli_query($db, $sql);


                           if (mysqli_num_rows($check_result) == 0) {

                               Attendance::create([
                                   'user_id' => $user_id,
                                   'punch_time' => $checktime,
                               ]);

                           }
                       }
                   }

 //                  echo $i . " Data In Successfully!";
   //                sleep(5);  // Sleep for 5 seconds before next cycle
     //              echo  "\n";

                   // Optionally remove exit() if you want the loop to continue running indefinitely
                   exit();
               }

        // Closing connections
        mysqli_close($db);
        odbc_close($connection);

    }
}
