<?php $__env->startSection('title', 'Device Information'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div class="d-flex justify-content-between align-items-center">
            <h5 class="card-header">Device Information</h5>

            <h5 class="card-header">
                <a href="<?php echo e(route('device.test_sound', $device->id)); ?>" class="btn btn-primary  mr-2">
                     Test Sound
                </a>
                <a href="<?php echo e(route('device.restart', $device->id)); ?>" class="btn btn-primary  mr-2">
                     Restart 
                </a>
                <a href="<?php echo e(route('device.shutdown', $device->id)); ?>" class="btn btn-primary  mr-2">
                     Shut Down
                </a>
                
            </h5>

        </div>
        <div class="card-body">
            <?php if(count($device_info) > 0): ?>
                <div class="table-responsive text-nowrap">
                    <table class="table table-bordered">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>Name</th>
                                <th>Information</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <th scope="row">1</th>
                                <td>Device IP</td>
                                <td><?php echo e($device_info['deviceip']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">2</th>
                                <td>Device Name</td>
                                <td><?php echo e($device_info['devicedeviceName']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">3</th>
                                <td>Device Version</td>
                                <td><?php echo e($device_info['deviceVersion']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">4</th>
                                <td>Device OS Version</td>
                                <td><?php echo e($device_info['deviceOSVersion']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">5</th>
                                <td>Device Platform</td>
                                <td><?php echo e($device_info['devicePlatform']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">6</th>
                                <td>Device Fm Version</td>
                                <td><?php echo e($device_info['devicefmVersion']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">7</th>
                                <td>Device Work Code</td>
                                <td><?php echo e($device_info['deviceworkCode']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">8</th>
                                <td>Device SSR</td>
                                <td><?php echo e($device_info['devicessr']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">9</th>
                                <td>Device Epin Width</td>
                                <td><?php echo e($device_info['devicepinWidth']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">10</th>
                                <td>Device Serial Number</td>
                                <td><?php echo e($device_info['deviceserialNumber']); ?></td>
                            </tr>
                            <tr>
                                <th scope="row">11</th>
                                <td>Device Time</td>
                                <td><?php echo e($device_info['devicegetTime']); ?></td>
                            </tr>

                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                Device Not Found
            <?php endif; ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\Gpush-v2\resources\views/pages/devices/show.blade.php ENDPATH**/ ?>