<?php $__env->startSection('title', 'Attendance'); ?>

<?php $__env->startSection('content'); ?>
    <div class="card">
        <div cla>

        </div>
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0">Attendance List </h5>
            <div>
                <a class="btn btn-primary btn-sm" href="<?php echo e(route('device.attendance')); ?>">Reload</a>
                
                <a class="btn btn-success btn-sm" href="<?php echo e(route('attendances.export')); ?>">Export Excel</a>

            </div>

        </div>

        <div class="card-body">
            <?php $__currentLoopData = $errors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="alert alert-danger alert-dismissible" role="alert">
                    <?php echo e($error['msg']); ?>

                    <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close">
                    </button>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="table-responsive text-nowrap">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th scope="col">#</th>
                            <th scope="col">Device ID</th>
                            <th scope="col">User ID</th>
                            <th scope="col">Timestamp</th>
                            <th scope="col">Type

                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $final_attendances; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $attendance): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th scope="row"><?php echo e($loop->iteration); ?></th>
                                <td><?php echo e($attendance['device_id']); ?></td>
                                <td><?php echo e($attendance['id']); ?></td>

                                <?php
                                    $date = date_create($attendance['timestamp']);
                                ?>
                                <td><?php echo e(date_format($date, 'd-M-Y h:i:s a')); ?></td>
                                <td><?php echo e($attendance['type'] == 0 ? 'Check IN' : 'Check Out'); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </tbody>
                </table>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/SHR/resources/views/pages/attendance/index.blade.php ENDPATH**/ ?>